/*
 * Decompiled with CFR 0.152.
 */
package jace.hardware;

import jace.apple2e.MOS65C02;
import jace.core.Computer;
import jace.core.Keyboard;
import jace.core.RAMEvent;
import jace.core.RAMListener;
import java.awt.Toolkit;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConsoleProbeSimple {
    RAMListener cout;
    public static int COUT = 65005;

    public void init(final Computer c) {
        Thread t = new Thread(new KeyReader());
        t.start();
        this.cout = new RAMListener(RAMEvent.TYPE.READ, RAMEvent.SCOPE.ADDRESS, RAMEvent.VALUE.ANY){

            protected void doConfig() {
                this.setScopeStart(COUT);
            }

            protected void doEvent(RAMEvent e) {
                if (c.getCpu().getProgramCounter() != COUT) {
                    return;
                }
                MOS65C02 cpu = (MOS65C02)c.getCpu();
                int ch = cpu.A & 0x7F;
                if (ch == 13) {
                    System.out.println();
                } else if (ch < 32) {
                    if (ch == 7) {
                        Toolkit.getDefaultToolkit().beep();
                    } else {
                        System.out.println("CHR" + ch);
                    }
                } else {
                    System.out.print((char)ch);
                }
            }
        };
        c.getMemory().addListener(this.cout);
    }

    public static class KeyReader
    implements Runnable {
        public Computer c;

        public void run() {
            while (true) {
                try {
                    while (true) {
                        if (System.in.available() == 0 || Keyboard.readState() < 0) {
                            try {
                                Thread.sleep(1L);
                            }
                            catch (InterruptedException ex) {
                                System.out.println(ex.getMessage());
                                Logger.getLogger(ConsoleProbeSimple.class.getName()).log(Level.SEVERE, null, ex);
                            }
                            continue;
                        }
                        int ch = System.in.read();
                        if (ch == 10) {
                            ch = 13;
                        }
                        Keyboard.pressKey((byte)ch);
                    }
                }
                catch (IOException ex) {
                    System.out.println(ex.getMessage());
                    Logger.getLogger(ConsoleProbeSimple.class.getName()).log(Level.SEVERE, null, ex);
                    continue;
                }
                break;
            }
        }
    }
}

